-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.forwardBase:LinkToTarget("questHilltop")
  end
end

function OnBeforeDeath(self)
  self.forwardBase:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("forwardBase")
end
